<?php
/* StarpayBD WHMCS Plugin
 *
 * Copyright (c) 2026
 * Website: https://securecheckoutio.com/
 * Company: StarpayBD
 */

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function starpaybd_MetaData()
{
    return array(
        'DisplayName' => 'StarpayBD',
        'APIVersion' => '1.0',
        'DisableLocalCredtCardInput' => true,
        'TokenisedStorage' => false,
    );
}

function starpaybd_config()
{
    return array(
        'FriendlyName' => array(
            'Type'  => 'System',
            'Value' => 'StarpayBD',
        ),
        'apiKey' => array(
            'FriendlyName' => 'API Key',
            'Type' => 'text',
            'Size' => '150',
            'Default' => '',
            'Description' => 'Enter your StarpayBD API Key',
        ),
        'currency_rate' => array(
            'FriendlyName' => 'Currency Rate',
            'Type' => 'text',
            'Size' => '50',
            'Default' => '85',
            'Description' => 'USD to BDT Rate',
        ),
    );
}

function starpaybd_link($params)
{
    if (isset($_POST['pay'])) {
        return starpaybd_payment_url($params);
    }

    return '<form method="POST">
        <input type="hidden" name="pay" value="1">
        <input class="btn btn-primary" type="submit" value="'.$params['langpaynow'].'" />
    </form>';
}

function starpaybd_payment_url($params)
{
    $cus_name  = $params['clientdetails']['firstname'].' '.$params['clientdetails']['lastname'];
    $cus_email = $params['clientdetails']['email'];

    $apikey        = $params['apiKey'];
    $currency_rate = $params['currency_rate'];
    $invoiceId     = $params['invoiceid'];

    if ($params['currency'] == "USD") {
        $amount = $params['amount'] * $currency_rate;
    } else {
        $amount = $params['amount'];
    }

    $protocol  = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $systemUrl = $protocol.$_SERVER['HTTP_HOST'];

    $webhook_url = $systemUrl.'/modules/gateways/callback/starpaybd.php?invoice='.$invoiceId;
    $success_url = $systemUrl.'/viewinvoice.php?id='.$invoiceId;
    $cancel_url  = $systemUrl.'/viewinvoice.php?id='.$invoiceId;

    $data = array(
        "cus_name"    => $cus_name,
        "cus_email"   => $cus_email,
        "amount"      => round($amount, 2),
        "webhook_url" => $webhook_url,
        "success_url" => $success_url,
        "cancel_url"  => $cancel_url,
    );

    $headers = array(
        'Content-Type: application/json',
        'API-KEY: '.$apikey,
    );

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://securecheckoutio.com/api/payment/create',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => $headers,
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    $res = json_decode($response, true);

    if (!empty($res['status']) && !empty($res['payment_url'])) {
        header("Location: ".$res['payment_url']);
        exit;
    } else {
        return '<div class="alert alert-danger">'.($res['message'] ?? 'Payment initialization failed').'</div>';
    }
}
