<?php
/* StarpayBD WHMCS Gateway Callback
 *
 * Company: StarpayBD
 * Website: https://securecheckoutio.com
 */

require_once __DIR__ . '/../../../init.php';
require_once __DIR__ . '/../../../includes/gatewayfunctions.php';
require_once __DIR__ . '/../../../includes/invoicefunctions.php';

use WHMCS\Config\Setting;

/* Gateway module name */
$gatewayModuleName = "starpaybd";

/* Get gateway configuration */
$gatewayParams = getGatewayVariables($gatewayModuleName);
if (!$gatewayParams["type"]) {
    die("Module Not Activated");
}

/* Callback data */
$invoiceId     = $_REQUEST['invoice'] ?? null;
$transactionId = $_REQUEST['transactionId'] ?? null;
$paymentAmount = $_REQUEST['paymentAmount'] ?? 0;
$paymentFee    = $_REQUEST['paymentFee'] ?? 0;

/* Validate invoice */
$invoiceId = checkCbInvoiceID($invoiceId, $gatewayModuleName);

/* Validate transaction ID */
checkCbTransID($transactionId);

/* Prepare verify request */
$data = array(
    "transaction_id" => $transactionId,
);

$headers = array(
    'Content-Type: application/json',
    'API-KEY: ' . $gatewayParams['apiKey'],
);

$curl = curl_init();
curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://securecheckoutio.com/api/payment/verify',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => $headers,
));

$response = curl_exec($curl);
curl_close($curl);

$result = json_decode($response, true);

/* Check payment status */
if (!empty($result['status']) && $result['status'] === "COMPLETED") {

    addInvoicePayment(
        $invoiceId,
        $transactionId,
        $paymentAmount,
        $paymentFee,
        $gatewayModuleName
    );

    $systemUrl = Setting::getValue('SystemURL');
    header("Location: ".$systemUrl."/viewinvoice.php?id=".$invoiceId);
    exit;

} else {

    logTransaction(
        $gatewayModuleName,
        $result,
        "Failed"
    );

    echo "Payment verification failed";
}
